/* 8BitAmEthernet
 * version 0.4.0 date 2006-04-13
 * Copyright 2005-2006 Stefan Schuermans <1stein@schuermans.info>
 * Copyleft: GNU public license - http://www.gnu.org/copyleft/gpl.html
 * a project of CCC-AC - http://www.cccac.de/
 */

#include <avr/io.h>

#include "debug.h"
#include "output.h"

//current output state
unsigned char OutputState = 0x00;

//debug output of current output state
static void OutputDebugOutput( void )
{
  debug_output_printf( "output state is now %u %u %u %u %u %u %u %u",
                       (OutputState & 0x01) != 0x00,
                       (OutputState & 0x02) != 0x00,
                       (OutputState & 0x04) != 0x00,
                       (OutputState & 0x08) != 0x00,
                       (OutputState & 0x10) != 0x00,
                       (OutputState & 0x20) != 0x00,
                       (OutputState & 0x40) != 0x00,
                       (OutputState & 0x80) != 0x00 );
}

//initialize
void OutputInit( void ) //(extern)
{
  //initialize output port
  DDRD = 0xFF;
  PORTD = OutputState;

  OutputDebugOutput( );
}

//get state of an output
char OutputGet( unsigned char OutputNo ) //(extern)
{
  if( OutputNo < 1 || OutputNo > 8 )
    return 0;
  return (OutputState >> (OutputNo - 1)) & 0x01;
}

//change output
//Action: 0=turn off, 1=turn on, -1=toggle
void OutputChange( signed char Action, unsigned char OutputNo ) //(extern)
{
  if( OutputNo < 1 || OutputNo > 8 )
    return;
  if( Action == 0 )
    OutputState &= ~(0x01 << (OutputNo - 1));
  else if( Action > 0 )
    OutputState |= 0x01 << (OutputNo - 1);
  else
    OutputState ^= 0x01 << (OutputNo - 1);
  PORTD = OutputState;

  OutputDebugOutput( );
}

//change all outputs
//Action: 0=turn off, 1=turn on, -1=toggle
void OutputChangeAll( signed char Action ) //(extern)
{
  if( Action == 0 )
    OutputState = 0x00;
  else if( Action > 0 )
    OutputState = 0xFF;
  else
    OutputState = ~OutputState;
  PORTD = OutputState;

  OutputDebugOutput( );
}

//get output state
unsigned char OutputGetState( void ) //(extern)
{
  return OutputState;
}

//set output state
void OutputSetState( unsigned char NewState ) //(extern)
{
  OutputState = NewState;
  PORTD = OutputState;

  OutputDebugOutput( );
}

