/* 8BitAmEthernet
 * version 0.4.0 date 2006-04-13
 * Copyright 2005-2006 Stefan Schuermans <1stein@schuermans.info>
 * Copyleft: GNU public license - http://www.gnu.org/copyleft/gpl.html
 * a project of CCC-AC - http://www.cccac.de/
 */

#ifndef INC_nethelp
#define INC_nethelp

//byte order
#define ntohs( n ) ( ((unsigned short)(n) & 0xFF00) >> 8 | \
                     ((unsigned short)(n) & 0x00FF) << 8 )
#define htons( h ) ( ((unsigned short)(h) & 0xFF00) >> 8 | \
                     ((unsigned short)(h) & 0x00FF) << 8 )
#define ntohl( n ) ( ((unsigned long)(n) & 0xFF000000) >> 24 | \
                     ((unsigned long)(n) & 0x00FF0000) >> 8 | \
                     ((unsigned long)(n) & 0x0000FF00) << 8 | \
                     ((unsigned long)(n) & 0x000000FF) << 24 )
#define htonl( h ) ( ((unsigned long)(h) & 0xFF000000) >> 24 | \
                     ((unsigned long)(h) & 0x00FF0000) >> 8 | \
                     ((unsigned long)(h) & 0x0000FF00) << 8 | \
                     ((unsigned long)(h) & 0x000000FF) << 24 )

//comparing MACs and IPs
#define mac_eq( a, b ) ( (a)[0] == (b)[0] && (a)[1] == (b)[1] && (a)[2] == (b)[2] && \
                         (a)[3] == (b)[3] && (a)[4] == (b)[4] && (a)[5] == (b)[5] )
#define ip_eq( a, b ) ( (a)[0] == (b)[0] && (a)[1] == (b)[1] && \
                        (a)[2] == (b)[2] && (a)[3] == (b)[3] )

//copying MACs and IPs
#define mac_cpy( dest, src ) ( (dest)[0] = (src)[0], (dest)[1] = (src)[1], (dest)[2] = (src)[2], \
                               (dest)[3] = (src)[3], (dest)[4] = (src)[4], (dest)[5] = (src)[5] )
#define ip_cpy( dest, src ) ( (dest)[0] = (src)[0], (dest)[1] = (src)[1], \
                              (dest)[2] = (src)[2], (dest)[3] = (src)[3] )

#endif //#ifndef INC_nethelp

