/* 8BitAmEthernet
 * version 0.4.0 date 2006-04-13
 * Copyright 2005-2006 Stefan Schuermans <1stein@schuermans.info>
 * Copyleft: GNU public license - http://www.gnu.org/copyleft/gpl.html
 * a project of CCC-AC - http://www.cccac.de/
 */

#ifndef INC_debug
#define INC_debug

#include <stdio.h>
#include <avr/pgmspace.h>

//debug configuration (what to debug)
#define DEBUG_INIT 1
#define DEBUG_EEPROM 1
#define DEBUG_KEYS 1
#define DEBUG_CODE 1
#define DEBUG_OUTPUT 1
#define DEBUG_RTL8019 1
#define DEBUG_ETHER 1
#define DEBUG_ARP 1
#define DEBUG_IP 1
#define DEBUG_ICMP 1
#define DEBUG_UDP 1
#define DEBUG_TCP 1
#define DEBUG_S8P 1
#define DEBUG_HTTP 1

//debug version of printf
#ifdef DEBUG
#define debug_printf( fmt, arg... ) \
  { \
    static const PROGMEM char fmt_pgm[] = fmt"\r\n"; \
    char fmt_buf[sizeof( fmt_pgm )]; \
    for( int i = 0; i < sizeof( fmt_pgm ); i++ ) \
      fmt_buf[i] = (char)pgm_read_byte_near( (uint16_t)fmt_pgm + i ); \
    printf( fmt_buf, ##arg ); \
  }
#else
#define debug_printf( fmt, arg... ) { }
#endif

//specialized debug versions of printf
#define debug_specialized_printf( enabled, fmt, arg... ) { if( enabled ) debug_printf( fmt, ##arg ); }
#define debug_init_printf( fmt, arg... ) debug_specialized_printf( DEBUG_INIT, "init: "fmt, ##arg )
#define debug_eeprom_printf( fmt, arg... ) debug_specialized_printf( DEBUG_EEPROM, "eeprom: "fmt, ##arg )
#define debug_keys_printf( fmt, arg... ) debug_specialized_printf( DEBUG_KEYS, "keys: "fmt, ##arg )
#define debug_code_printf( fmt, arg... ) debug_specialized_printf( DEBUG_CODE, "code: "fmt, ##arg )
#define debug_output_printf( fmt, arg... ) debug_specialized_printf( DEBUG_OUTPUT, "output: "fmt, ##arg )
#define debug_rtl8019_printf( fmt, arg... ) debug_specialized_printf( DEBUG_RTL8019, "rtl8019: "fmt, ##arg )
#define debug_ether_printf( fmt, arg... ) debug_specialized_printf( DEBUG_ETHER, "ether: "fmt, ##arg )
#define debug_arp_printf( fmt, arg... ) debug_specialized_printf( DEBUG_ARP, "arp: "fmt, ##arg )
#define debug_ip_printf( fmt, arg... ) debug_specialized_printf( DEBUG_IP, "ip: "fmt, ##arg )
#define debug_icmp_printf( fmt, arg... ) debug_specialized_printf( DEBUG_ICMP, "icmp: "fmt, ##arg )
#define debug_udp_printf( fmt, arg... ) debug_specialized_printf( DEBUG_UDP, "udp: "fmt, ##arg )
#define debug_tcp_printf( fmt, arg... ) debug_specialized_printf( DEBUG_TCP, "tcp: "fmt, ##arg )
#define debug_s8p_printf( fmt, arg... ) debug_specialized_printf( DEBUG_S8P, "s8p: "fmt, ##arg )
#define debug_http_printf( fmt, arg... ) debug_specialized_printf( DEBUG_HTTP, "http: "fmt, ##arg )

#endif //#ifndef INC_debug
