/* 8BitAmEthernet
 * version 0.3 date 2006-01-29
 * Copyright 2005-2006 Stefan Schuermans <1stein@schuermans.info>
 * Copyleft: GNU public license - http://www.gnu.org/copyleft/gpl.html
 * a project of CCC-AC - http://www.cccac.de/
 */

#ifndef INC_xtea
#define INC_xtea

#include <stdint.h>

//XTEA encryption
//rounds should be at least 32
//p_in == p_out is allowed
//p_prev must be initialized to zero before first call to this function
extern void xtea_enc( uint32_t key[4], uint8_t rounds, uint64_t * p_in, uint64_t * p_out, unsigned int block_cnt, uint64_t * p_prev );

//XTEA decryption
//rounds should be at least 32
//p_in == p_out is allowed
//p_prev must be initialized to zero before first call to this function
extern void xtea_dec( uint32_t key[4], uint8_t rounds, uint64_t * p_in, uint64_t * p_out, unsigned int block_cnt, uint64_t * p_prev );

#endif //#ifndef INC_xtea
