/* 8BitAmEthernet
 * version 0.3 date 2006-01-29
 * Copyright 2005-2006 Stefan Schuermans <1stein@schuermans.info>
 * Copyleft: GNU public license - http://www.gnu.org/copyleft/gpl.html
 * a project of CCC-AC - http://www.cccac.de/
 */

#include <avr/interrupt.h>
#include <avr/wdt.h>

#include "arp.h"
#include "debug.h"
#include "eeprom.h"
#include "http.h"
#include "keypad.h"
#include "output.h"
#include "random.h"
#include "rtl8019.h"
#include "s8p.h"
#include "tcp.h"
#include "timing.h"
#include "uart.h"

//main code entry point
int main( void )
{
  wdt_reset( );
  wdt_enable( WDTO_60MS );
  wdt_reset( );

  //initialize uart to be able to use stdio
  UartInit( );

  debug_print( "" );
  debug_print( "" );
  debug_print( "init" );

  //initialize modules
  ArpInit( );
  HttpInit( );
  KeypadInit( );
  OutputInit( );
  RtlInit( );
  S8pInit( );
  TcpInit( );
  TimingInit( );

  debug_print( "config" );

  //get configuration from EEPROM
  EepromGetConfig( );

  //enable interrupts
  sei( );

  debug_print( "start" );

  //main loop
  while( 1 )
  {
    wdt_reset( );
    EepromTask( );
    KeypadTask( );
    RandomTask( );
    RtlTask( );
    S8pTask( );
    TimingTask( );
  }

  return 0;
}

