/* 8BitAmEthernet
 * version 0.3.2 date 2006-04-08
 * Copyright 2005-2006 Stefan Schuermans <1stein@schuermans.info>
 * Copyleft: GNU public license - http://www.gnu.org/copyleft/gpl.html
 * a project of CCC-AC - http://www.cccac.de/
 */

#include <avr/interrupt.h>
#include <avr/wdt.h>

#include "arp.h"
#include "debug.h"
#include "eeprom.h"
#include "http.h"
#include "keypad.h"
#include "output.h"
#include "random.h"
#include "rtl8019.h"
#include "s8p.h"
#include "tcp.h"
#include "timing.h"
#include "uart.h"

//main code entry point
int main( void )
{
  wdt_reset( );
#ifdef DEBUG
  wdt_disable( );
#else
  wdt_enable( WDTO_60MS );
#endif
  wdt_reset( );

  //initialize uart to be able to use stdio
  UartInit( );

  debug_printf( "" );
  debug_printf( "8BitAmEthernet" );

  debug_init_printf( "init" );

  //initialize modules
  ArpInit( );
  HttpInit( );
  KeypadInit( );
  OutputInit( );
  RtlInit( );
  S8pInit( );
  TcpInit( );
  TimingInit( );

  debug_init_printf( "config" );

  //get configuration from EEPROM
  EepromGetConfig( );

  //enable interrupts
  sei( );

  debug_init_printf( "start" );

  //main loop
  while( 1 )
  {
    wdt_reset( );
    EepromTask( );
    wdt_reset( );
    KeypadTask( );
    wdt_reset( );
    RandomTask( );
    wdt_reset( );
    RtlTask( );
    wdt_reset( );
    S8pTask( );
    wdt_reset( );
    TimingTask( );
  }

  return 0;
}

