/* 8BitAmEthernet
 * version 0.3.2 date 2006-04-08
 * Copyright 2005-2006 Stefan Schuermans <1stein@schuermans.info>
 * Copyleft: GNU public license - http://www.gnu.org/copyleft/gpl.html
 * a project of CCC-AC - http://www.cccac.de/
 */

#ifndef INC_arp
#define INC_arp

#include "ethernet.h"

//header of an ARP packet
struct ArpHeader
{
  unsigned short HwType;
  unsigned short ProtoType;
  unsigned char HwLen;
  unsigned char ProtoLen;
  unsigned short Op;
  unsigned char SrcMac[6];
  unsigned char SrcIp[4];
  unsigned char DestMac[6];
  unsigned char DestIp[4];
};

//an ARP packet
struct ArpPacket
{
  struct EthernetHeader EthHdr;
  struct ArpHeader ArpHdr;
};

//initialize
extern void ArpInit( void );

//tick procedure - call every 200ms
extern void ArpTick200( void );

//process a received ARP packet
extern void ArpRecv( unsigned char * pData, unsigned short Length );

//lookup the MAC for an IP address
//returns 0x00 in case of success, 0x01 if the MAC address is unknown
extern unsigned char ArpLookup( unsigned char * pIp, unsigned char * pMac );

#endif //#ifdef INC_arp

