/* 8BitAmEthernet
 * version 0.3.1 date 2006-03-12
 * Copyright 2005-2006 Stefan Schuermans <1stein@schuermans.info>
 * Copyleft: GNU public license - http://www.gnu.org/copyleft/gpl.html
 * a project of CCC-AC - http://www.cccac.de/
 */

#include <stdio.h>
#include <avr/io.h>
#include <avr/wdt.h>

#include "macros.h"
#include "uart.h"

#define BAUD_RATE 38400

//initialize
void UartInit( void ) //(extern)
{
  //enable transmission
  UCSR0B = 1<<TXEN;
  //set baudrate (16MHz crystal) 
  UBRR0L = 16000000 / (BAUD_RATE * 16L) - 1;

  //set STDOUT to use UartPutchar
  fdevopen( UartPutchar, NULL, 0 );
}

//write a character
int UartPutchar( char c ) //(extern)
{
  //wait until last character was sent
  while( bit_is_clear( UCSR0A, UDRE ) )
    wdt_reset( );

  //send character
  UDR0 = c;

  return 0;
}

