/* 8BitAmEthernet
 * version 0.3.1 date 2006-03-12
 * Copyright 2005-2006 Stefan Schuermans <1stein@schuermans.info>
 * Copyleft: GNU public license - http://www.gnu.org/copyleft/gpl.html
 * a project of CCC-AC - http://www.cccac.de/
 */

#ifndef INC_ethernet
#define INC_ethernet

//header of an ethernet packet
struct EthernetHeader
{
  unsigned char Dest[6];
  unsigned char Src[6];
  unsigned short Type;
};

//an ethernet packet
struct EthernetPacket
{
  struct EthernetHeader EthHdr;
};

//process a received ethernet packet
extern void EthernetRecv( unsigned char * pData, unsigned short Length );

//send an ethernet packet
//pData must point to a struct EthernetPacket with EthHdr.Dest and EthHdr.Type already initialized
extern void EthernetSend( unsigned char * pData, unsigned short Length );

#endif //#ifdef INC_ethernet

