/* 8BitAmEthernet
 * version 0.2 date 2005-03-07
 * Copyright 2005 Stefan Schuermans <1stein@schuermans.info>
 * Copyleft: GNU public license - http://www.gnu.org/copyleft/gpl.html
 * a project of CCC-AC - http://www.cccac.de/
 */

#ifndef INC_rtl8019
#define INC_rtl8019

//initialize
extern void RtlInit( void );

//re-initialize RT8019 (i.e. if MAC changed)
//must be called with interrupts disabled
extern void RtlReinit( void );

//tick procedure - call every 200ms from timer interrupt
//must be called with interrupts disabled
extern void RtlTick200( void );

//write an ethernet frame to the RTL8019
//must be called with interrupts disabled
extern void RtlWriteFrame( char * pData, unsigned short Length );

//read an ethernet frame from the RTL8019
//*pLength must be initialized to the buffer size
//must be called with interrupts disabled
extern void RtlReadFrame( char * pData, unsigned short * pLength );

#endif //#ifndef INC_rtl8019

