/* 8BitAmEthernet
 * version 0.2.1 date 2005-03-08
 * Copyright 2005 Stefan Schuermans <1stein@schuermans.info>
 * Copyleft: GNU public license - http://www.gnu.org/copyleft/gpl.html
 * a project of CCC-AC - http://www.cccac.de/
 */

#include <avr/interrupt.h>
#include <avr/wdt.h>

#include "arp.h"
#include "eeprom.h"
#include "http.h"
#include "keypad.h"
#include "output.h"
#include "rtl8019.h"
#include "s8p.h"
#include "tcp.h"
#include "timing.h"
#include "uart.h"

//main code entry point
int main( void )
{
  wdt_reset( );
  wdt_enable( WDTO_60MS );
  wdt_reset( );

  //initialize uart to be able to use stdio
  UartInit( );

  //initialize modules
  ArpInit( );
  HttpInit( );
  KeypadInit( );
  OutputInit( );
  RtlInit( );
  S8pInit( );
  TcpInit( );
  TimingInit( );

  //get configuration from EEPROM
  EepromGetConfig( );

  //enable interrupts
  sei( );
  
  //main loop
  while( 1 )
  {
    wdt_reset( );
    EepromTask( );
    KeypadTask( );
    S8pTask( );
  }

  return 0;
}

