/* 8BitAmEthernet
 * version 0.1 date 2005-02-21
 * Copyright 2005 Stefan Schuermans <1stein@schuermans.info>
 * Copyleft: GNU public license - http://www.gnu.org/copyleft/gpl.html
 * a project of CCC-AC - http://www.cccac.de/
 */

#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/signal.h>

#include "arp.h"
#include "ip.h"
#include "keypad.h"
#include "timing.h"
#include "udp.h"

//wrapping 2ms tick counter
volatile unsigned char Timing2 = 0; //(extern)

//2ms tick counter to generate 200ms ticks
volatile unsigned char Timing2_100 = 0;

//2ms interrupt (timer 0 compare match)
SIGNAL( SIG_OUTPUT_COMPARE0 )
{
  //call 2ms tick functions
  KeypadTick2( );

  //count 2ms steps
  Timing2++;

  //generate 200ms steps
  Timing2_100++;
  if( Timing2_100 >= 100 )
  {
    Timing2_100 = 0;

    //call 200ms tick functions
    ArpTick200( );
    IpTick200( );
    UdpTick200( );
  }
}

//initialize
void TimingInit( void ) //(extern)
{
  //configure timer 0 to 2ms interval
  TCCR0 = 0<<FOC0 | 1<<WGM01 | 0<<WGM00 | //count to OCR0
          0<<COM01 | 0<<COM00 | //no waveform generation
          1<<CS02 | 1<<CS01 | 0<<CS02; //1/256 of sysclock (16MHz) -> increment every 16us
  OCR0 = 124; //count to 124 -> 2ms interval

  //enable timer 0 compare match interrupt
  TIMSK |= 1<<OCIE0;

  //configure timer 1 to count cycles
  TCCR1A = 0<<WGM11 | 0<<WGM10; //normal mode
  TCCR1B = 0<<WGM13 | 0<<WGM12 | 0<<CS12 | 0<<CS11 | 1<<CS10; //normal mode, no prescaler
}

//get number of cycles elapsed
//must be called with interrupts disabled
unsigned short TimingGetCycles( void ) //(extern)
{
  return TCNT1;
}

