/* 8BitAmEthernet
 * version 0.1 date 2005-02-21
 * Copyright 2005 Stefan Schuermans <1stein@schuermans.info>
 * Copyleft: GNU public license - http://www.gnu.org/copyleft/gpl.html
 * a project of CCC-AC - http://www.cccac.de/
 */

#include <avr/io.h>
#include <avr/interrupt.h>

#include "arp.h"
#include "eeprom.h"
#include "keypad.h"
#include "rtl8019.h"
#include "timing.h"
#include "uart.h"

//main code entry point
int main( void )
{
  //initialize output port
  DDRD = 0xFF;
  PORTD = 0x00;
  
  //initialize uart to be able to use stdio
  UartInit( );

  //initialize modules
  ArpInit( );
  KeypadInit( );
  RtlInit( );
  TimingInit( );

  //get configuration from EEPROM
  EepromGetConfig( );

  //enable interrupts
  sei( );
  
  //main loop
  while( 1 )
  {
    EepromTask( );
    KeypadTask( );
  }

  return 0;
}

