/* 8BitAmEthernet
 * version 0.1 date 2005-02-21
 * Copyright 2005 Stefan Schuermans <1stein@schuermans.info>
 * Copyleft: GNU public license - http://www.gnu.org/copyleft/gpl.html
 * a project of CCC-AC - http://www.cccac.de/
 */

#ifndef INC_macros
#define INC_macros

//minimum and maximum
#define min( a, b ) ((a) < (b) ? (a) : (b))
#define max( a, b ) ((a) > (b) ? (a) : (b))

//number of entries in an array
#define count( array ) (sizeof( (array) ) / sizeof( (array)[0] ))

//waiting
#define nop( ) { __asm__ __volatile__ ("nop"::); }

//bit manipulation
#define bit_set( var, bit ) (var |= (1 << bit))
#define bit_clear( var, bit ) (var &= ~(1 << bit))
#define bit_toggle( var, bit ) (var ^= (1 << bit))

//byte order
#define ntohs( n ) ( (unsigned short)(n) >> 8 | (unsigned short)(n) << 8 )
#define htons( h ) ( (unsigned short)(h) >> 8 | (unsigned short)(h) << 8 )

//comparing MACs and IPs
#define mac_eq( a, b ) ( (a)[0] == (b)[0] && (a)[1] == (b)[1] && (a)[2] == (b)[2] && \
                         (a)[3] == (b)[3] && (a)[4] == (b)[4] && (a)[5] == (b)[5] )
#define ip_eq( a, b ) ( (a)[0] == (b)[0] && (a)[1] == (b)[1] && \
                        (a)[2] == (b)[2] && (a)[3] == (b)[3] )

//copying MACs and IPs
#define mac_cpy( dest, src ) ( (dest)[0] = (src)[0], (dest)[1] = (src)[1], (dest)[2] = (src)[2], \
                               (dest)[3] = (src)[3], (dest)[4] = (src)[4], (dest)[5] = (src)[5] )
#define ip_cpy( dest, src ) ( (dest)[0] = (src)[0], (dest)[1] = (src)[1], \
                              (dest)[2] = (src)[2], (dest)[3] = (src)[3] )

#endif //#ifndef INC_macros

