/* 8BitAmEthernet
 * version 0.1 date 2005-02-21
 * Copyright 2005 Stefan Schuermans <1stein@schuermans.info>
 * Copyleft: GNU public license - http://www.gnu.org/copyleft/gpl.html
 * a project of CCC-AC - http://www.cccac.de/
 */

#ifndef INC_ip
#define INC_ip

#include "ethernet.h"

//header of an IP packet
struct IpHeader
{
  unsigned char Ver_HdrLen;
  unsigned char Tos;
  unsigned int TotalLen;
  unsigned int Id;
  unsigned int FragOfs;
  unsigned char Ttl;
  unsigned char Proto;
  unsigned int HdrChk;
  unsigned char Src[4];
  unsigned char Dest[4];
};

//an IP packet
struct IpPacket
{
  struct EthernetHeader EthHdr;
  struct IpHeader IpHdr;
};

//tick procedure - call every 200ms from timer interrupt
//must be called with interrupts disabled
extern void IpTick200( void );

//process a received IP packet
//must be called with interrupts disabled
extern void IpRecv( unsigned char * pData, unsigned short Length );

//send an IP packet
//pData must point to a struct IpPacket with IpHdr.Proto and IpHdr.Dest already initialized
//must be called with interrupts disabled
extern void IpSend( unsigned char * pData, unsigned short Length );

//a MAC address was discovered
//called by ARP to notify IP
//must be called with interrupts disabled
extern void IpGotMac( unsigned char Ip[4], unsigned char Mac[6] );

#endif //#ifdef INC_ip

