/* 8BitAmEthernet - LuminoWand
 * version 0.2.1 date 2005-08-17
 * Copyright 2005 Stefan Schuermans <1stein@schuermans.info>
 * Copyleft: GNU public license - http://www.gnu.org/copyleft/gpl.html
 * a project of CCC-AC - http://www.cccac.de/
 */

#ifndef INC_udp
#define INC_udp

#include "ethernet.h"
#include "ip.h"

//header of an UDP packet
struct UdpHeader
{
  unsigned int SrcPort;
  unsigned int DestPort;
  unsigned int Length;
  unsigned int Chk;
};

//an UDP packet
struct UdpPacket
{
  struct EthernetHeader EthHdr;
  struct IpHeader IpHdr;
  struct UdpHeader UdpHdr;
};

//tick procedure - call every 200ms from timer interrupt
//must be called with interrupts disabled
extern void UdpTick200( void );

//process a received UDP packet
//must be called with interrupts disabled
extern void UdpRecv( unsigned char * pData, unsigned short Length );

//send an UDP packet
//pData must point to a struct UdpPacket with UdpHdr.SrcPort, UdpHdr.DestPort and IpHdr.Dest already initialized
//must be called with interrupts disabled
extern void UdpSend( unsigned char * pData, unsigned short Length );

#endif //#ifdef INC_udp

