/* 8BitAmEthernet - LuminoWand
 * version 0.2.1 date 2005-08-17
 * Copyright 2005 Stefan Schuermans <1stein@schuermans.info>
 * Copyleft: GNU public license - http://www.gnu.org/copyleft/gpl.html
 * a project of CCC-AC - http://www.cccac.de/
 */

#include <output.h>

//current output state
volatile unsigned char OutputState = 0x00;

//initialize
void OutputInit( void ) //(extern)
{
}

//get state of an output
//must be called with interrupts turned off
char OutputGet( unsigned char OutputNo ) //(extern)
{
  if( OutputNo < 1 || OutputNo > 8 )
    return 0;
  return (OutputState >> (OutputNo - 1)) & 0x01;
}

//change output
//Action: 0=turn off, 1=turn on, -1=toggle
//must be called with interrupts turned off
void OutputChange( signed char Action, unsigned char OutputNo ) //(extern)
{
  if( OutputNo < 1 || OutputNo > 8 )
    return;
  if( Action == 0 )
    OutputState &= ~(0x01 << (OutputNo - 1));
  else if( Action > 0 )
    OutputState |= 0x01 << (OutputNo - 1);
  else
    OutputState ^= 0x01 << (OutputNo - 1);
}

//get output state
//must be called with interrupts turned off
unsigned char OutputGetState( void ) //(extern)
{
  return OutputState;
}

//set output state
//must be called with interrupts turned off
void OutputSetState( unsigned char NewState ) //(extern)
{
  OutputState = NewState;
}

