/* 8BitAmEthernet - LuminoWand
 * version 0.2.1 date 2005-08-17
 * Copyright 2005 Stefan Schuermans <1stein@schuermans.info>
 * Copyleft: GNU public license - http://www.gnu.org/copyleft/gpl.html
 * a project of CCC-AC - http://www.cccac.de/
 */

#include <avr/interrupt.h>
#include <avr/wdt.h>

#include "arp.h"
#include "eeprom.h"
#include "keypad.h"
#include "lumino.h"
#include "output.h"
#include "rtl8019.h"
#include "timing.h"
#include "uart.h"

//main code entry point
int main( void )
{
  wdt_reset( );
  wdt_enable( WDTO_60MS );
  wdt_reset( );

  //initialize uart to be able to use stdio
  UartInit( );

  //initialize modules
  ArpInit( );
  KeypadInit( );
  OutputInit( );
  LuminoInit( );
  RtlInit( );
  TimingInit( );

  //get configuration from EEPROM
  EepromGetConfig( );

  //enable interrupts
  sei( );
  
  //main loop
  while( 1 )
  {
    wdt_reset( );
    EepromTask( );
    KeypadTask( );
  }

  return 0;
}

