/* 8BitAmEthernet - LuminoWand
 * version 0.2.1 date 2005-08-17
 * Copyright 2005 Stefan Schuermans <1stein@schuermans.info>
 * Copyleft: GNU public license - http://www.gnu.org/copyleft/gpl.html
 * a project of CCC-AC - http://www.cccac.de/
 */

#ifndef INC_icmp
#define INC_icmp

#include "ethernet.h"
#include "ip.h"

//header of an ICMP packet
struct IcmpHeader
{
  unsigned char Type;
  unsigned char Code;
  unsigned int Chk;
};

//an ICMP packet
struct IcmpPacket
{
  struct EthernetHeader EthHdr;
  struct IpHeader IpHdr;
  struct IcmpHeader IcmpHdr;
};

//header of an ICMP echo request/reply packet
struct IcmpEchoHeader
{
  unsigned int Id;
  unsigned int Seq;
};

//an ICMP echo request/reply packet
struct IcmpEchoPacket
{
  struct EthernetHeader EthHdr;
  struct IpHeader IpHdr;
  struct IcmpHeader IcmpHdr;
  struct IcmpEchoHeader EchoHdr;
};

//process a received ICMP packet
//must be called with interrupts disabled
extern void IcmpRecv( unsigned char * pData, unsigned short Length );

#endif //#ifdef INC_icmp

