/* 8BitAmEthernet - LuminoWand
 * version 0.2.1 date 2005-08-17
 * Copyright 2005 Stefan Schuermans <1stein@schuermans.info>
 * Copyleft: GNU public license - http://www.gnu.org/copyleft/gpl.html
 * a project of CCC-AC - http://www.cccac.de/
 */

#include "arp.h"
#include "config.h"
#include "ethernet.h"
#include "ip.h"
#include "macros.h"
#include "nethelp.h"
#include "rtl8019.h"

//process a received ethernet packet
//must be called with interrupts disabled
void EthernetRecv( unsigned char * pData, unsigned short Length ) //(extern)
{
  struct EthernetPacket * pEthPack;

  //packet too short
  if( Length < sizeof( struct EthernetPacket ) )
    return;

  //convert pointer to ethernet packet
  //(this saves us from always casting pData)
  pEthPack = (struct EthernetPacket *)pData;

  //branch according to packet type
  switch( pEthPack->EthHdr.Type )
  {
    //ARP
    case htons( 0x0806 ):
      ArpRecv( pData, Length );
      break;
    //IP
    case htons( 0x0800 ):
      IpRecv( pData, Length );
      break;
  }
}

//send an ethernet packet
//pData must point to a struct EthernetPacket with EthHdr.Dest and EthHdr.Type already initialized
//must be called with interrupts disabled
void EthernetSend( unsigned char * pData, unsigned short Length ) //(extern)
{
  struct EthernetPacket * pEthPack;

  //packet too short
  if( Length < sizeof( struct EthernetPacket ) )
    return;

  //convert pointer to ethernet packet
  //(this saves us from always casting pData)
  pEthPack = (struct EthernetPacket *)pData;

  //fill in source address
  mac_cpy( pEthPack->EthHdr.Src, ConfigMac );

  //send packet
  RtlWriteFrame( pData, Length );
}

